/*
 * @brief SCTimer/PWM (SCT) Repetitive Interrupt example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"


/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/


void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                  															// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_32BIT_COUNTER  |												// unified timers,
                              SCT_CONFIG_AUTOLIMIT_L    );										// auto limit

	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, 	(SystemCoreClock/100) - 1); //match 0 @ 100 Hz = 10 msec

	Chip_SCT_EventControl(LPC_SCT, 0, SCT_EVECTRL_MATCH0);              				// match 0 condition only

	Chip_SCT_EventStateMask(LPC_SCT, 0, ENABLE_ALL_STATES);											// event 0 happens in all states


	Chip_SCT_EnableEventInt(LPC_SCT,SCT_EVT_0);																	// event 0 generates an interrupt

  NVIC_EnableIRQ(SCT_IRQn);                             											// enable SCT interrupt

  Chip_SCT_ClearControl(LPC_SCT,SCT_CTRL_HALT_L);															// start timer

}



void SCT_IRQHandler(void)																											// SCT Interrupt Handler (10 msec)
{
	 static uint8_t cnt = 0;

	    if (++cnt > 20)                                													// 20 * 10 msec = 200 msec
	    {
	        cnt = 0;
	        Chip_GPIO_SetPinToggle(LPC_GPIO , 0, 29); 													// toggle pin P0_29 (RED LED)
	    }
	    Chip_SCT_SetEventFlag(LPC_SCT,SCT_EVT_0);  															// clear event 0 flag
}


int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();

	SCT_Init();																																	// Initialize SCT

	while (1)                                         													// loop forever
	{
		__WFI();
	}
}


